  
#declare Noise = function {
  pigment {
    crackle 
    turbulence 0.1
    color_map { [0 rgb 1] [1 rgb 0] }
    scale 0.5
    }
  }

#declare F_Trunk = function { x*x+z*z- (0.4+0.5*exp(-0.5*(y+0.5)*(y+0.5)) - 0.02*y) }

#declare Redwood = isosurface {
  function { F_Trunk( x, y, z ) - 0.035*sin(15*f_th(x,y,z)+3*y)  - 0.01*sin(23*f_th(x,y,z)-0.7*y) - 0.01*sin(37*f_th(x,y,z)+0.3*y)  
  + 0.03*f_noise_generator(30*x,3*y,30*z, 3)+ 0.02*f_noise_generator(20*x,5*y,20*z, 3) }
  contained_by { box { <-1, -1, -1> <1, 8, 1> } }    
  max_gradient 3.33
  
  //Bark pigment with a little roughness
  texture { 
    pigment {
      granite
      scale <0.4, 2, 0.4>
      color_map { 
        [ 0.0 rgb <0.570, 0.391, 0.250> ]
        [ 0.3 rgb <0.792, 0.636, 0.496> ]
        [ 0.6 rgb <0.648, 0.469, 0.277> ]
        [ 1.0 rgb <0.926, 0.813, 0.742> ]
        }
      }
    normal {
      average 
      normal_map {
        [ 1.0 granite turbulence 0.3 scale 0.1*<1, 3,  1> ]
        [ 1.0 crackle 2 poly_wave 0.2 scale <0.1, 2, 0.1> turbulence 0.2 ]
        }
      }
    #if ( Radious = 1 ) finish { ambient 0 } #end
    }


  //Moss on <1, 0, -1> side of tree
  texture {
    pigment {
      slope { <1.5, 0, -1> altitude <0, 1, 0>, 4, 0 } 
      turbulence 0.4
      scale <0.5, 2, 0.5>
      color_map {
        [0.0 rgbt <1.0, 1.0, 1.0, 1.0> ]
        [0.6 rgbt <1.0, 1.0, 1.0, 1.0> ]
        [0.8 rgbt <0.289, 0.371, 0.117, 0.0> ]
        [1.0 rgbt <0.395, 0.477, 0.207, 0.0> ]
        }
      }
    normal { bumps 1 scale 0.001 }
    #if ( Radious = 1 ) finish { ambient 0 } #end
    }
  }

#macro Make_Redwood ( F1, a1, F2, a2, F3, a3, h )
#warning concat( "Make_Redwood parameters: ", str(F1,1,4), " ", str(a1,1,4), " ", str(F2,1,4), " ", str(a2,1,4), " ", str(F3,1,4), " ", str(a3,1,4), " ", str(h,1,4), "\n" )
isosurface {
  function { F_Trunk( x, y, z ) - 0.035*sin(F1*f_th(x,y,z)+a1*y)  - 0.01*sin(F2*f_th(x,y,z)-a2*y) - 0.01*sin(F3*f_th(x,y,z)+a3*y)  
  + 0.03*f_noise_generator(30*x,3*y,30*z, 3)+ 0.02*f_noise_generator(20*x,5*y,20*z, 3) }
  contained_by { box { <-1, -1, -1> <1, h, 1> } }    
  max_gradient 3.33
  
  //Bark pigment with a little roughness
  texture { 
    pigment {
      granite
      rotate <360*rand(r), 360*rand(r), 360*rand(r)>
      scale <0.4, 2, 0.4>
      color_map { 
        [ 0.0 rgb <0.570, 0.391, 0.250> ]
        [ 0.3 rgb <0.792, 0.636, 0.496> ]
        [ 0.6 rgb <0.648, 0.469, 0.277> ]
        [ 1.0 rgb <0.926, 0.813, 0.742> ]
        }
      }
    normal {
      average 
      normal_map {
        [ 1.0 granite turbulence 0.3 scale 0.1*<1, 3,  1> ]
        [ 1.0 crackle 2 poly_wave 0.2 scale <0.1, 2, 0.1> turbulence 0.2 ]
        }
      }
    #if ( Radious = 1 ) finish { ambient 0 } #end
    }

  //Moss on <1, 0, -1> side of tree
  texture {
    pigment {
      slope { <1.5, 0, -1> altitude <0, 1.5, 0>, 6, 0 } 
      turbulence 0.4
      scale <0.5, 2, 0.5>
      color_map {
        [0.0 rgbt <1.0, 1.0, 1.0, 1.0> ]
        [0.55 rgbt <1.0, 1.0, 1.0, 1.0> ]
        [0.75 rgbt <0.289, 0.371, 0.117, 0.0> ]
        [1.0 rgbt <0.395, 0.477, 0.207, 0.0> ]
        }
      }
    normal { bumps 1 scale 0.001 }
    #if ( Radious = 1 ) finish { ambient 0 } #end
    }
  } 
#end